/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.supplementaries.compat.inspirations;

import java.util.List;
import java.util.function.Supplier;
import knightminer.inspirations.library.recipe.cauldron.CauldronContentTypes;
import knightminer.inspirations.library.recipe.cauldron.contents.CauldronContentType;
import knightminer.inspirations.library.recipe.cauldron.contents.ICauldronContents;
import knightminer.inspirations.recipes.recipe.cauldron.contents.CauldronContents;
import knightminer.inspirations.recipes.tileentity.CauldronTileEntity;
import net.mehvahdjukaar.selene.fluids.SoftFluid;
import net.mehvahdjukaar.selene.fluids.SoftFluidHolder;
import net.mehvahdjukaar.selene.fluids.SoftFluidRegistry;
import net.minecraft.fluid.Fluid;
import net.minecraft.fluid.Fluids;
import net.minecraft.item.DyeColor;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.Potion;
import net.minecraft.potion.PotionUtils;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;

public class CauldronPlugin {
    public static boolean doStuff(TileEntity cauldronTile, SoftFluidHolder faucetFluidHolder, boolean doTransfer, Supplier<Boolean> transferBelow) {
        if (cauldronTile instanceof CauldronTileEntity) {
            int level;
            int levelToBottleEquivalent;
            SoftFluid equivalent;
            CauldronTileEntity te = (CauldronTileEntity)cauldronTile;
            ICauldronContents contents = te.getContents();
            CauldronContentType contentType = contents.getType();
            CompoundNBT nbt = new CompoundNBT();
            if (contentType == CauldronContentTypes.FLUID) {
                Fluid f = (Fluid)contents.get(contentType).get();
                equivalent = SoftFluidRegistry.fromForgeFluid((Fluid)f);
                levelToBottleEquivalent = 3;
                if (f == Fluids.field_204546_a) {
                    levelToBottleEquivalent = 4;
                }
            } else if (contentType == CauldronContentTypes.POTION) {
                Potion potion = (Potion)contents.get(contentType).get();
                equivalent = SoftFluidRegistry.POTION;
                nbt.func_74778_a("Potion", potion.getRegistryName().toString());
                nbt.func_74778_a("Bottle", "REGULAR");
                levelToBottleEquivalent = 4;
            } else if (contentType == CauldronContentTypes.DYE) {
                DyeColor dye = (DyeColor)contents.get(contentType).get();
                equivalent = SoftFluidRegistry.get((String)("inspirations:" + dye.func_176610_l() + "_dye"));
                levelToBottleEquivalent = 4;
            } else {
                return false;
            }
            faucetFluidHolder.fill(equivalent, nbt);
            if (doTransfer && (level = te.getLevel()) >= levelToBottleEquivalent && transferBelow.get().booleanValue()) {
                te.updateStateAndBlock(contents, level - levelToBottleEquivalent);
                te.func_70296_d();
            }
            if (!doTransfer) {
                return !faucetFluidHolder.isEmpty();
            }
            return true;
        }
        return false;
    }

    public static boolean tryAddFluid(TileEntity cauldronTile, SoftFluidHolder faucetFluidHolder) {
        if (cauldronTile instanceof CauldronTileEntity) {
            CauldronTileEntity te = (CauldronTileEntity)cauldronTile;
            SoftFluid s = faucetFluidHolder.getFluid();
            CompoundNBT com = faucetFluidHolder.getNbt();
            ResourceLocation name = s.getRegistryName();
            int level = te.getLevel();
            ICauldronContents contents = te.getContents();
            CauldronContentType contentType = contents.getType();
            int levelToBottleEquivalent = 4;
            if (name.func_110624_b().equals("inspirations") && name.func_110623_a().contains("_dye")) {
                DyeColor color = DyeColor.func_204271_a((String)name.func_110623_a().replace("_dye", ""), (DyeColor)DyeColor.WHITE);
                if (level == 0) {
                    te.updateStateAndBlock((ICauldronContents)new CauldronContents(CauldronContentTypes.DYE, (Object)color), levelToBottleEquivalent);
                    te.func_70296_d();
                    return true;
                }
                if (level + levelToBottleEquivalent <= 12 && contentType == CauldronContentTypes.DYE && contents.get(CauldronContentTypes.DYE).get() == color) {
                    te.updateStateAndBlock(contents, level + levelToBottleEquivalent);
                    te.func_70296_d();
                    return true;
                }
            } else if (s == SoftFluidRegistry.POTION) {
                if (com.func_74779_i("Bottle").equals("REGULAR")) {
                    Potion potion = PotionUtils.func_185187_c((CompoundNBT)com);
                    if (level == 0) {
                        te.updateStateAndBlock((ICauldronContents)new CauldronContents(CauldronContentTypes.POTION, (Object)potion), levelToBottleEquivalent);
                        te.func_70296_d();
                        return true;
                    }
                    if (level + levelToBottleEquivalent <= 12 && contentType == CauldronContentTypes.POTION && contents.get(CauldronContentTypes.POTION).get() == potion) {
                        te.updateStateAndBlock(contents, level + levelToBottleEquivalent);
                        te.func_70296_d();
                        return true;
                    }
                }
            } else {
                List fluids = s.getEquivalentFluids();
                if (!fluids.isEmpty()) {
                    if (s != SoftFluidRegistry.WATER) {
                        levelToBottleEquivalent = 3;
                    }
                    if (level == 0) {
                        te.updateStateAndBlock((ICauldronContents)new CauldronContents(CauldronContentTypes.FLUID, (Object)((Fluid)fluids.get(0))), levelToBottleEquivalent);
                        te.func_70296_d();
                        return true;
                    }
                    if (level + levelToBottleEquivalent <= 12 && contentType == CauldronContentTypes.FLUID && s.isEquivalent((Fluid)contents.get(CauldronContentTypes.FLUID).get())) {
                        te.updateStateAndBlock(contents, level + levelToBottleEquivalent);
                        te.func_70296_d();
                        return true;
                    }
                }
            }
        }
        return false;
    }
}

